Attribute VB_Name = "modDataFormatting"
Option Explicit

Public Function Abbr(ByVal S As String) As String
    If Not Options.Abbreviate Then Abbr = S: Exit Function
    S = Replace$(S, "@Lordaeron", vbNullString)
    S = Replace$(S, "@Azeroth", vbNullString)
    S = Replace$(S, "@Northrend", vbNullString)
    S = Replace$(S, "@Kalimdor", vbNullString)
    S = Replace$(S, "@USWest", vbNullString)
    S = Replace$(S, "@USEast", vbNullString)
    S = Replace$(S, "@Europe", vbNullString)
    S = Replace$(S, "@Asia", vbNullString)
    Abbr = S
End Function

Public Function Dayeth(Day As Long) As String
    Select Case Val(Right$(Day, 1))
    Case 1:     Dayeth = Day & "st"
    Case 2:     Dayeth = Day & "nd"
    Case 3:     Dayeth = Day & "rd"
    Case Else:  Dayeth = Day & "th"
    End Select
End Function

Public Function FixFilename(ByVal str As String) As String
    str = Replace$(str, ":", vbNullString)
    str = Replace$(str, "<", vbNullString)
    str = Replace$(str, ">", vbNullString)
    str = Replace$(str, "?", vbNullString)
    str = Replace$(str, "/", vbNullString)
    str = Replace$(str, "\", vbNullString)
    str = Replace$(str, "*", vbNullString)
    str = Replace$(str, ChrW$(34), vbNullString)
    str = Replace$(str, "|", vbNullString)
    FixFilename = Trim$(str)
End Function



'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CHANNEL/USER RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Function FlagsToString(Flags As Long) As String
    Dim buf As String
    If (Flags And &H1) Then buf = buf & "Representative, "
    If (Flags And &H2) Then buf = buf & "Operator, "
    If (Flags And &H4) Then buf = buf & "Speaker, "
    If (Flags And &H8) Then buf = buf & "Administrator, "
    If (Flags And &H10) Then buf = buf & "Plugged, "
    If (Flags And &H20) Then buf = buf & "Squelched, "
    If (Flags And &H40) Then buf = buf & "Guest, "
    If (Flags And &H100) Then buf = buf & "Beep, "
    If (Flags And &H100000) Then buf = buf & "Jailed, "
    If Len(buf) = 0 Then buf = "Normal"
    If Right$(buf, 2) = ", " Then buf = Left$(buf, Len(buf) - 2)
    FlagsToString = buf
End Function
Public Function ChannelFlagsToString(ChannelFlags As Long) As String
    Dim buf As String
    If (ChannelFlags And CHANNEL_PUBLIC) Then buf = buf & "Public, "
    If (ChannelFlags And CHANNEL_MODERATED) Then buf = buf & "Moderated, "
    If (ChannelFlags And CHANNEL_RESTRICTED) Then buf = buf & "Restricted, "
    If (ChannelFlags And CHANNEL_SILENT) Then buf = buf & "Silent, "
    If (ChannelFlags And CHANNEL_SYSTEM) Then buf = buf & "System, "
    If (ChannelFlags And CHANNEL_PRODUCTSPECIFIC) Then buf = buf & "Product Specific, "
    If (ChannelFlags And CHANNEL_GLOBAL) Then buf = buf & "Global, "
    If Len(buf) = 0 Then buf = "Private"
    If Right$(buf, 2) = ", " Then buf = Left$(buf, Len(buf) - 2)
    ChannelFlagsToString = buf
End Function
Public Function PingBars(ByVal Ping As Long) As String
    If Ping = -1 Then PingBars = "6 red": Exit Function
    If Ping > 600 Then PingBars = "6 red": Exit Function
    If Ping > 500 Then PingBars = "5 red": Exit Function
    If Ping > 400 Then PingBars = "4 yellow": Exit Function
    If Ping > 300 Then PingBars = "3 yellow": Exit Function
    If Ping > 200 Then PingBars = "2 green": Exit Function
    If Ping > 9 Then PingBars = "1 green": Exit Function
    PingBars = "No bars"
End Function
Public Function IsEliteName(ByVal sName As String) As Boolean
    'Remove potential realm suffix
    sName = StripGateway(sName)
    'Define illegal characters
    Const parallel As String = "()[].-_", illegal As String = "`~!@$^&+={};:|'"
    'Assume illegal
    IsEliteName = True
    'Check first character
    If InStrB(parallel, Left$(sName, 1)) <> 0 Then Exit Function
    'Check for parallel characters
    Dim X As Integer
    For X = 1 To Len(sName) - 1
        If InStrB(parallel, Mid(sName, X, 1)) <> 0 And _
            InStrB(parallel, Mid$(sName, X + 1, 1)) <> 0 Then Exit Function
    Next
    'Check for illegal characters
    For X = 1 To Len(sName)
        If InStrB(illegal, Mid$(sName, X, 1)) <> 0 Then Exit Function
    Next X
    'Legal account
    IsEliteName = False
End Function
Public Function IsRandomName(sName As String) As Boolean
On Error Resume Next
    Dim FChar As Boolean, SChar As Boolean, Div As Integer, Tally As Integer
    Select Case Len(sName)
    Case Is >= 12: Div = 4
    Case Is >= 8: Div = 3
    Case Else: Div = 2
    End Select
    Dim X As Integer
    For X = 1 To Len(sName) - 1
        FChar = IsNumeric(Mid$(sName, X, 1))
        SChar = IsNumeric(Mid$(sName, X + 1, 1))
        
        If Not FChar = SChar Then Tally = Tally + Div
    Next X
    If Tally >= (Len(sName) / Div) Then IsRandomName = True
End Function
Public Function IsRandomName2(Username As String) As Boolean
On Error Resume Next
    If LenB(Username) < 8 Then Exit Function
    Const vowelratio As Double = 0.5
    Dim vowels As Double, Other As Double, I As Integer
    For I = 1 To Len(Username)
        Select Case LCase$(Mid$(Username, I, 1))
        Case "a", "e", "i", "o", "u"
            vowels = vowels + 1
        Case "[", "]", "{", "}", "(", ")", "!", "$", "^", _
            "&", ".", ";", ":", "'"
            Exit Function
        Case "@"
        Case Else
            Other = Other + 1
        End Select
    Next I
    Dim userRatio As Double
    userRatio = (vowels / Other)
    If userRatio > vowelratio Then Exit Function
    IsRandomName2 = True
End Function
Public Function WhoUser(Username As String) As String
    If UCase$(Username) = Username Then
        If Left$(Username, 1) = "[" And Right$(Username, 1) = "]" Then
            WhoUser = Mid$(Username, 2, Len(Username) - 2)
        Else
            WhoUser = Username
        End If
    Else
        WhoUser = Username
    End If
    If InStr(WhoUser, " (*") > 0 Then
        WhoUser = Suffix(WhoUser, " (")
        If Right(WhoUser, 1) = ")" Then WhoUser = Left$(WhoUser, Len(WhoUser) - 1)
    End If
End Function
Public Function Suffix(str As String, Optional Char As String = "*")
    If InStrB(str, Char) <> 0 Then
        Suffix = Mid$(str, InStrRev(str, Char) + 1)
    Else
        Suffix = str
    End If
End Function
Public Function Prefix(str As String, Optional Char As String = "*")
    If InStrB(str, Char) <> 0 Then
        Prefix = Left$(str, InStr(str, Char) - 1)
    Else
        Prefix = str
    End If
End Function
Public Function ExtractNum(Username As String) As String
    If InStrB(Username, "#") = 0 Then ExtractNum = 0: Exit Function
    Dim num As String
    num = Split(Username, "#")(1)
    If InStrB(num, "@") <> 0 Then num = Split(num, "@")(0)
    ExtractNum = num
End Function





'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' FRIEND RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Function FriendStatus(Status As Byte, Optional Online As Boolean = True) As String
    Dim buf As String
    If (Status And &H1) Then buf = "Mutual Friend, "
    If (Status And &H2) Then buf = buf & "DND, "
    If (Status And &H4) Then buf = buf & "Away"
    If Right$(buf, 2) = ", " Then buf = Left$(buf, Len(buf) - 2)
    If LenB(buf) = 0 Then If Online Then buf = "Online" Else buf = "Offline"
    FriendStatus = buf
End Function
Public Function FriendLocation(Location As Byte) As String
    Select Case Location
    Case &H0: FriendLocation = "Offline"
    Case &H1: FriendLocation = "Not in chat"
    Case &H2: FriendLocation = "In chat"
    Case &H3: FriendLocation = "In a public game"
    Case &H4: FriendLocation = "In a private game"
    Case &H5: FriendLocation = "In a password protected game"
    Case Else: FriendLocation = "Unknown"
    End Select
End Function






'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' CLAN RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Function ClanRankEnumToString(Rank As CLANRANKENUM) As String
    Select Case Rank
        Case CLANRANKENUM.INITIATE: ClanRankEnumToString = "Initiate"
        Case CLANRANKENUM.PEON: ClanRankEnumToString = "Peon"
        Case CLANRANKENUM.GRUNT: ClanRankEnumToString = "Grunt"
        Case CLANRANKENUM.SHAMAN: ClanRankEnumToString = "Shaman"
        Case CLANRANKENUM.CHIEFTAIN: ClanRankEnumToString = "Chieftain"
    End Select
End Function
Public Function ClanRankToString(Rank As Byte) As String
    Select Case Rank
        Case &H0: ClanRankToString = "Initiate"
        Case &H1: ClanRankToString = "Peon"
        Case &H2: ClanRankToString = "Grunt"
        Case &H3: ClanRankToString = "Shaman"
        Case &H4: ClanRankToString = "Chieftain"
    End Select
End Function
Public Function ClanStatusToString(Status As Byte) As String
    Select Case Status
    Case &H0: ClanStatusToString = "Offline"
    Case &H1: ClanStatusToString = "Online"
    Case &H2: ClanStatusToString = "In a channel"
    Case &H3: ClanStatusToString = "In a public game"
    Case &H5: ClanStatusToString = "In a private game"
    Case Else: ClanStatusToString = "Unknown"
    End Select
End Function






'\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\\
' SERVER RELATED
'///////////////////////////////////////////////////////////////////////////////
Public Function GetServerName(Server As String, Optional IsWarCraft As Boolean = False) As String
    If InStrB(Server, ".") <> 0 Then
        Dim range As String
        range = Left$(Server, InStrRev(Server, ".") - 1)
        If range = "63.241.83" Then
            GetServerName = "USWest"
        ElseIf range = "63.240.202" Then
            GetServerName = "USEast"
        ElseIf range = "211.233.0" Then
            GetServerName = "Asia"
        ElseIf range = "213.248.106" Then
            GetServerName = "Europe"
        Else
            Select Case LCase$(Server)
            Case "uswest.battle.net"
                GetServerName = "USWest"
            Case "useast.battle.net"
                GetServerName = "USEast"
            Case "asia.battle.net"
                GetServerName = "Asia"
            Case "europe.battle.net"
                GetServerName = "Europe"
            Case Else
                GetServerName = "PvPGN (" & Server & ")"
            End Select
        End If
        
        If IsWarCraft Then
            If GetServerName = "USWest" Then GetServerName = "Lordaeron"
            If GetServerName = "USEast" Then GetServerName = "Azeroth"
            If GetServerName = "Europe" Then GetServerName = "Northrend"
            If GetServerName = "Asia" Then GetServerName = "Kalimdor"
        End If
    Else
        GetServerName = "PvPGN (" & Server & ")"
    End If
End Function
Public Function ServerMatch(server1 As String, server2 As String) As Boolean
    ServerMatch = GetServerName(server1) = GetServerName(server2)
End Function
Public Function IsOnGateway(Username As String) As Boolean
    If (InStr(Username, "@USWest") > 0) Or (InStr(Username, "@USEast") > 0) Or (InStr(Username, "@Asia") > 0) Or (InStr(Username, "@Europe") > 0) Or _
       (InStr(Username, "@Lordaeron") > 0) Or (InStr(Username, "@Azeroth") > 0) Or (InStr(Username, "@Kalimdor") > 0) Or (InStr(Username, "@Northrend") > 0) Then
        IsOnGateway = True
    Else
        IsOnGateway = False
    End If
End Function
Public Function StripGateway(ByVal sName As String) As String
    StripGateway = sName
    If Len(sName) > 5 Then
        If Right$(sName, 7) = "@USWest" Or Right$(sName, 7) = "@USEast" Or _
                Right$(sName, 5) = "@Asia" Or Right$(sName, 7) = "@Europe" Or _
                Right$(sName, 10) = "@Lordaeron" Or Right$(sName, 8) = "@Azeroth" Or _
                Right$(sName, 9) = "@Kalimdor" Or Right$(sName, 10) = "@Northrend" Then
            StripGateway = Left$(sName, InStrRev(sName, "@") - 1)
        End If
    End If
End Function

